/*****************************************************************************/
/*                                Includes
/*****************************************************************************/

#include "DataAcquisition.h"
  
/*****************************************************************************/
/*                               Definitions
/*****************************************************************************/
 
#define NAME_COORDS      89,53     //////////////////////////////////
#define AGE_COORDS       70,53     //                              //
#define GENDER_COORDS    70,133    // Screen position coords (X,Y) //
#define HEIGHT_COORDS    52,53     //                              //
#define WEIGHT_COORDS    35,53     //                              //
#define RESET_COORDS     9,137     //////////////////////////////////
 
#define NAME_FIELD_CFG   NAME_COORDS,12,LETTER_FIELD,gau8NameArray
#define AGE_FIELD_CFG    AGE_COORDS,2,NUMBER_FIELD,gau8AgeArray
#define GENDER_FIELD_CFG GENDER_COORDS,1,GENDER_FIELD,gau8GenderArray
#define HEIGHT_FIELD_CFG HEIGHT_COORDS,3,NUMBER_FIELD,gau8HeightArray
#define WEIGHT_FIELD_CFG WEIGHT_COORDS,3,NUMBER_FIELD,gau8WeightArray
 
#define BACKGROUND_COLOR White
#define UNSELECTED_COLOR New_fntcolor(Black,BACKGROUND_COLOR);
#define SELECTED_COLOR   New_fntcolor(White,Black);

#define CHARACTER_BLOCK  8         //Character Block Size
  
/*****************************************************************************/
/*                          Typedefs and Structs
/*****************************************************************************/

typedef enum{
  LETTER_FIELD,
  NUMBER_FIELD,
  GENDER_FIELD
}FIELD_TYPES;
 
typedef enum{
  NAME_CASE=1,
  AGE_CASE=2,
  GENDER_CASE=3,
  HEIGHT_CASE=4,
  WEIGHT_CASE=5,
  RESET_CASE=6
}FIELD_CASES;

/*****************************************************************************/
/*                                 Globals
/*****************************************************************************/

UINT8 gau8NameArray[13];
UINT8 gau8AgeArray[3];
UINT8 gau8GenderArray [2];
UINT8 gau8HeightArray [4];
UINT8 gau8WeightArray [4];
UINT8 gu8FirstTimeData=False;

/*****************************************************************************/
/*                           MAIN DATA ROUTINE
/*****************************************************************************/

void vfnDataAcquisitionMenu (void){

  UINT8 u8FieldIndex, u8ButtonPressed=False, u8DataModified=False;
    
  /* Get Personal Data from SD */
  vfnGetSDPersonalData ();
  
  /* Print Background */
  vfnPrint_SD_Image("DATAMENU.AMI",0,0);
  
  u8FieldIndex=7;
  gu8ButtonStatus=BUTTON_IDDLE;
  
  /* Refresh Data Fields */
  vfnRefreshPersonalData (u8FieldIndex);
  
  /* Main Periodical Routine */
  while (gu8ButtonStatus != BUTTON_EXIT){ 
   
    TSS_Task(); //Touch Sensing Periodical Task
    
    /* Switch Selected Field (Age, Weight, Name, etc) */
    switch (gu8ButtonStatus){
    
      /*
      case BUTTON_UP:
      u8FieldIndex--;
      if(u8FieldIndex<1)
      u8FieldIndex=6;
      u8ButtonPressed=True;
      break;
      */
    
      /* Select Next Field */
      case BUTTON_LEFT:
      u8FieldIndex--;
      if(u8FieldIndex<1)
      u8FieldIndex=6;
      u8ButtonPressed=True;
      break;
    
      /*
      case BUTTON_DOWN:
      u8FieldIndex++;
      if(u8FieldIndex>6)
      u8FieldIndex=1;
      u8ButtonPressed=True;
      break;
      */
    
      /* Select Before Field */
      case BUTTON_RIGHT:
      u8FieldIndex++;
      if(u8FieldIndex>6)
      u8FieldIndex=1;
      u8ButtonPressed=True;
      break;
    
      /* Select Field for Editing */
      case BUTTON_SELECT:
      switch (u8FieldIndex){
        
        /* Edit Name */
        case NAME_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        vfnDataFieldEdit(NAME_FIELD_CFG);
        break;
      
        /* Edit Age */
        case AGE_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        vfnDataFieldEdit(AGE_FIELD_CFG);
        break;                                                    
      
        /* Edit Gender */
        case GENDER_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        vfnDataFieldEdit(GENDER_FIELD_CFG);
        break;
      
        /* Edit Height */
        case HEIGHT_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        vfnDataFieldEdit(HEIGHT_FIELD_CFG);
        break;
      
        /* Edit Weight */
        case WEIGHT_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        vfnDataFieldEdit(WEIGHT_FIELD_CFG);
        break;
      
        /* Reset Button */
        case RESET_CASE:
        gu8ButtonStatus=BUTTON_IDDLE;
        Calctr=0;
        u32Steps_Counter=0;
        u32StepsCountSDHandler(SAVE_STEPS);
        u32CaloriesCountSDHandler(SAVE_CALORIES);
        break;
      
        default:
        break;
      }
      u8ButtonPressed=True;
      u8DataModified=True;
      break;
  
      default:
      break;
    }
    
    /* If field edited then Refresh */
    if(u8ButtonPressed){
      vfnRefreshPersonalData(u8FieldIndex);
      gu8ButtonStatus=BUTTON_IDDLE;
      u8ButtonPressed=False;
    }

  }
  
  /* SAVE CHANGES */
  if(u8DataModified)
  vfnSavePersonalData();
}

/*****************************************************************************/
/*                           Get Personal Data from SD
/*****************************************************************************/

void vfnGetSDPersonalData (void){

  UINT16 u16SD_Buffer=0;
  volatile UINT16 u16SD_Phyblocksize=0;
  UINT16 u16SD_BufferIndex;
  volatile UINT8  SD_Status;
  UINT8 u8buffer[512];
  UINT8 u8ArrayIndex;
 
  vfnClearBuffer(Buffer_SD,22);
   
   
  SD_Status= FAT_FileOpen(DATA_FILE,READ);
 
  if(SD_Status==FILE_FOUND){
     
    do{
       
      /* FAT_FileRead returns how many bytes were read */
      /* Read a complete file, this function will be invoked until it returns zero */
      u16SD_Phyblocksize = FAT_FileRead(u8buffer); 
       
      for(u16SD_BufferIndex=0; u16SD_BufferIndex<u16SD_Phyblocksize; u16SD_BufferIndex++){
        Buffer_SD[u16SD_Buffer]=u8buffer[u16SD_BufferIndex];
        u16SD_Buffer++; 
      }
     
    }
    while (u16SD_Phyblocksize);
   
  }else{
   
    Fulldisplay(Convert_888_to_565(Darkblue,1),Convert_888_to_565(Darkblue,0));
    New_fntcolor(White,Darkblue);
    Write_Str_LCD((UINT8*)"File can not be found",(UINT8)(127-ltrheight),0);
    Write_Str_LCD((UINT8*)"File system may be corrupt",(UINT8)(127-2*ltrheight),0);
    for(;;){}
   
  }
   
  if(gu8FirstTimeData){   
    gu8FirstTimeData=False;
    vfnFillArray(Buffer_SD,"USER        00M000000",21);
  }
   
  u16SD_Buffer=0;
   
  /*Get Name Data*/
  u8ArrayIndex=0;
  while(u16SD_Buffer<12){
    gau8NameArray[u8ArrayIndex]=Buffer_SD[u16SD_Buffer];
    u8ArrayIndex++;
    u16SD_Buffer++;
  }
  gau8NameArray[u8ArrayIndex]=0;
    
  /*Get Age Data*/
  u8ArrayIndex=0;
  while (u16SD_Buffer<14){
    gau8AgeArray[u8ArrayIndex]=Buffer_SD[u16SD_Buffer];
    u8ArrayIndex++;
    u16SD_Buffer++;
  }
  gau8AgeArray[u8ArrayIndex]=0;
    
  /*Get Gender Data*/
  u8ArrayIndex=0;
  while (u16SD_Buffer<15){
    gau8GenderArray[u8ArrayIndex]=Buffer_SD[u16SD_Buffer];
    u8ArrayIndex++;
    u16SD_Buffer++;
  }
  gau8GenderArray[u8ArrayIndex]=0;
    
  /*Get Height Data*/
  u8ArrayIndex=0;
  while (u16SD_Buffer<18){
    gau8HeightArray[u8ArrayIndex]=Buffer_SD[u16SD_Buffer];
    u8ArrayIndex++;
    u16SD_Buffer++;
  }         
  gau8HeightArray[u8ArrayIndex]=0;
    
  /*Get Weight Data*/
  u8ArrayIndex=0;
  while (u16SD_Buffer<21){
    gau8WeightArray[u8ArrayIndex]=Buffer_SD[u16SD_Buffer];
    u8ArrayIndex++;
    u16SD_Buffer++;
  }
  gau8WeightArray[u8ArrayIndex]=0;
    
}
  
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

void vfnCheckSDforPersonalData (void){
 
  UINT8 u8FileStatus;
   
  u8FileStatus = FAT_FileOpen(DATA_FILE,READ);
  
  if(u8FileStatus==FILE_NOT_FOUND){
    u8FileStatus=FAT_FileOpen(DATA_FILE,CREATE);        
    gu8FirstTimeData=True;
    FAT_FileClose();
    vfnDataAcquisitionMenu();
  }
    
  gu8ButtonStatus=BUTTON_IDDLE;
}
  
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

void vfnRefreshPersonalData (UINT8 u8SelectedField){

  UNSELECTED_COLOR;
  
  vfnClearFields(NAME_COORDS,12);
  Write_Str_LCD(gau8NameArray,NAME_COORDS);
  vfnClearFields(AGE_COORDS,2);
  Write_Str_LCD(gau8AgeArray,AGE_COORDS);
  vfnClearFields(GENDER_COORDS,1);
  Write_Str_LCD(gau8GenderArray,GENDER_COORDS);
  vfnClearFields(HEIGHT_COORDS,3);
  Write_Str_LCD(gau8HeightArray,HEIGHT_COORDS);
  vfnClearFields(WEIGHT_COORDS,3);
  Write_Str_LCD(gau8WeightArray,WEIGHT_COORDS);
  vfnPrint_SD_Image("USELRST.AMI",RESET_COORDS); 
   
  SELECTED_COLOR;
  switch(u8SelectedField){
  
    case NAME_CASE:
    vfnPaintSelectedFields(NAME_COORDS,12);
    Write_Str_LCD(gau8NameArray,NAME_COORDS);
    break;                                                
      
    case AGE_CASE:
    vfnPaintSelectedFields(AGE_COORDS,2);
    Write_Str_LCD(gau8AgeArray,AGE_COORDS);
    break;                                                    
      
    case GENDER_CASE:
    vfnPaintSelectedFields(GENDER_COORDS,1);
    Write_Str_LCD(gau8GenderArray,GENDER_COORDS);
    break;
      
    case HEIGHT_CASE:
    vfnPaintSelectedFields(HEIGHT_COORDS,3);
    Write_Str_LCD(gau8HeightArray,HEIGHT_COORDS);
    break;
      
    case WEIGHT_CASE:
    vfnPaintSelectedFields(WEIGHT_COORDS,3);
    Write_Str_LCD(gau8WeightArray,WEIGHT_COORDS);
    break;
      
    case RESET_CASE:
    vfnPrint_SD_Image("SELRST.AMI",RESET_COORDS);
    break;
      
    default:
    break;
   
  }
   
  vfnCaloricExpenditureCalc();

}
  
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/

void vfnDataFieldEdit (UINT8 u8XCoords,UINT8 u8YCoords,UINT8 u8DataFieldsNumber,UINT8 u8FieldType,UINT8 *pu8StringtoEdit){

  UINT8 u8ActualXCoords, u8ActualYCoords;
  UINT8 u8FieldCounter=1;
  UINT8 au8LetterBuffer[2];
  UINT8* pu8DataString=pu8StringtoEdit;
  UINT8 u8PreviousGenderState;
  UINT8 u8ButtonPressed=False; 
  
  /*Inicialization for first time*/
  gu8ButtonStatus=BUTTON_IDDLE;
  au8LetterBuffer[1]=0;
  au8LetterBuffer[0]=*pu8StringtoEdit;
  u8ActualXCoords=u8XCoords;
  u8ActualYCoords=u8YCoords;
  u8PreviousGenderState=au8LetterBuffer[0];
  
  vfnClearFields(u8XCoords,u8YCoords,u8DataFieldsNumber);
  UNSELECTED_COLOR;
  vfnFillCharacterBlock(pu8DataString,u8XCoords,u8YCoords);
  vfnClearFields(u8ActualXCoords,u8ActualYCoords,1);
  SELECTED_COLOR;
  vfnFillCharacterBlock(au8LetterBuffer,u8ActualXCoords,u8ActualYCoords);  
  gu8ButtonStatus=BUTTON_IDDLE; 
  
  while(gu8ButtonStatus!=BUTTON_SELECT){
  
    TSS_Task();
    switch (gu8ButtonStatus){
    
      case BUTTON_UP:
      au8LetterBuffer[0]++;
      u8ButtonPressed=True;
      break;
    
      case BUTTON_DOWN:
      au8LetterBuffer[0]--;
      u8ButtonPressed=True;
      break;
    
      case BUTTON_RIGHT:    
      pu8StringtoEdit++;
      au8LetterBuffer[0]=*pu8StringtoEdit;
      u8FieldCounter++;
      u8ButtonPressed=True;
      break;
    
      case BUTTON_LEFT:
      pu8StringtoEdit--;
      au8LetterBuffer[0]=*pu8StringtoEdit;
      u8FieldCounter--;
      u8ButtonPressed=True;
      break;
    
      default:
      break;
   
    }
  
   
    if(u8FieldCounter>u8DataFieldsNumber){
      pu8StringtoEdit--;
      u8FieldCounter--;
      au8LetterBuffer[0]=*pu8StringtoEdit;
    }
   
    if(u8FieldCounter<1){
      pu8StringtoEdit++;
      u8FieldCounter++;\
      au8LetterBuffer[0]=*pu8StringtoEdit;
    }
   
    switch (u8FieldType){
   
      case LETTER_FIELD:
      if(au8LetterBuffer[0]<'A' && au8LetterBuffer[0]>' ')
        au8LetterBuffer[0]='A';
      if(au8LetterBuffer[0]<' ')
        au8LetterBuffer[0]='Z';
      if(au8LetterBuffer[0]>'Z')
        au8LetterBuffer[0]=' ';
      break;
    
      case NUMBER_FIELD:
      if(au8LetterBuffer[0]<'0')
        au8LetterBuffer[0]='9';
      if(au8LetterBuffer[0]>'9')
        au8LetterBuffer[0]='0';
      break;
    
      case GENDER_FIELD:
      if(u8ButtonPressed){
        if(u8PreviousGenderState=='M'){
          au8LetterBuffer[0]='F';
        }else{
          au8LetterBuffer[0]='M';
        }
        u8PreviousGenderState=au8LetterBuffer[0];
      }
      break;
    
      default:
      break;
    }
   
    *pu8StringtoEdit=au8LetterBuffer[0];
   
    u8ActualYCoords=(UINT8)((u8FieldCounter-1)*CHARACTER_BLOCK+u8YCoords); 
   
    if(u8ButtonPressed){
      vfnClearFields(u8XCoords,u8YCoords,u8DataFieldsNumber);
      UNSELECTED_COLOR;
      vfnFillCharacterBlock(pu8DataString,u8XCoords,u8YCoords);
      vfnClearFields(u8ActualXCoords,u8ActualYCoords,1);
      SELECTED_COLOR;
      vfnFillCharacterBlock(au8LetterBuffer,u8ActualXCoords,u8ActualYCoords);  
      gu8ButtonStatus=BUTTON_IDDLE;
    }
    u8ButtonPressed=False; 
  
  }
  UNSELECTED_COLOR;
  vfnClearFields(u8XCoords,u8YCoords,u8DataFieldsNumber);
  Write_Str_LCD(pu8DataString,u8XCoords,u8YCoords);

}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnFillCharacterBlock (UINT8* pu8StringtoPrint,UINT8 u8XCoords,UINT8 u8YCoords){
  
  UINT8 au8PrintArray[2];
   
  au8PrintArray[1]=0;//Print Array: [0]->Character to be printed [1]->Always 0
   
  while(*pu8StringtoPrint){
    au8PrintArray[0]=*pu8StringtoPrint;
    Write_Str_LCD(au8PrintArray,u8XCoords,u8YCoords);
    u8YCoords+=CHARACTER_BLOCK;
    pu8StringtoPrint++;
  } 

}
  
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
  
void vfnClearFields (UINT8 u8XCoords,UINT8 u8YCoords,UINT8 u8FieldsCount){
   
  UINT8 u8XEndPosition, u8YEndPosition;
  UINT8 u8ColorLB, u8ColorHB;
   
  u8ColorLB=Convert_888_to_565(BACKGROUND_COLOR,LOWBYTE);
  u8ColorHB=Convert_888_to_565(BACKGROUND_COLOR,HIGHBYTE);
   
  u8XEndPosition=(UINT8)(u8XCoords+ltrheight-1);
  u8YEndPosition=(UINT8)((u8FieldsCount*CHARACTER_BLOCK+u8YCoords)-1);
   
  colorArea(u8XCoords,u8XEndPosition,u8YCoords,u8YEndPosition,u8ColorHB,u8ColorLB);
   
}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnClearBuffer (UINT8* pu8BuffertoClear,UINT32 u32BufferSize){
 
  UINT32 u32BufferIndex;
   
  for(u32BufferIndex=0;u32BufferIndex<u32BufferSize;u32BufferIndex++){
    *pu8BuffertoClear=0;
    pu8BuffertoClear++;
  }

}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnSavePersonalData (void){

  UINT8 au8SavingBuffer[22], u8SavingBufferIndex;
  UINT8 u8FieldIndex;
  UINT8 u8SDFileStatus;
   
  u8SavingBufferIndex=0;
   
  for(u8FieldIndex=0;u8FieldIndex<12;u8FieldIndex++){
    au8SavingBuffer[u8SavingBufferIndex]=gau8NameArray[u8FieldIndex];
    u8SavingBufferIndex++;
  }
   
  for(u8FieldIndex=0;u8FieldIndex<2;u8FieldIndex++){
    au8SavingBuffer[u8SavingBufferIndex]=gau8AgeArray[u8FieldIndex];
    u8SavingBufferIndex++;
  }
   
  au8SavingBuffer[u8SavingBufferIndex]=gau8GenderArray[0];
  u8SavingBufferIndex++;
   
  for (u8FieldIndex=0;u8FieldIndex<3;u8FieldIndex++){
    au8SavingBuffer[u8SavingBufferIndex]=gau8HeightArray[u8FieldIndex];
    u8SavingBufferIndex++;
  }
   
  for (u8FieldIndex=0;u8FieldIndex<3;u8FieldIndex++){
    au8SavingBuffer[u8SavingBufferIndex]=gau8WeightArray[u8FieldIndex];
    u8SavingBufferIndex++;
  }
   
  u8SDFileStatus=FAT_FileOpen(DATA_FILE,OVERWRITE);
  
  if(u8SDFileStatus==FILE_FOUND){
    FAT_FileWrite((UINT8*)au8SavingBuffer,21);
  }else{
    Write_Str_LCD("ERROR!!!",0,0);
    for(;;){}
  }
   
  FAT_FileClose();
   
}

/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
  
void vfnPaintSelectedFields (UINT8 u8XCoords,UINT8 u8YCoords,UINT8 u8FieldsCount){
  
  UINT8 u8XEndPosition, u8YEndPosition;
  UINT8 u8ColorLB, u8ColorHB;
   
  u8ColorLB=Convert_888_to_565(Black,LOWBYTE);
  u8ColorHB=Convert_888_to_565(Black,HIGHBYTE);
   
  u8XEndPosition=(UINT8)(u8XCoords+ltrheight-1);
  u8YEndPosition=(UINT8)((--u8FieldsCount*CHARACTER_BLOCK+u8YCoords)-1);
   
  colorArea(u8XCoords,u8XEndPosition,u8YCoords,u8YEndPosition,u8ColorHB,u8ColorLB);
   
}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnFillArray (UINT8* pu8Array, UINT8* pu8Data, UINT8 u8DataCount){
  for(;u8DataCount>0;u8DataCount--){
    *pu8Array=*pu8Data;
    pu8Array++;
    pu8Data++;
  }
}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnCaloricExpenditureCalc (void){
  
  UINT32 u32CaloricExpenditure;

  /* Taking 0.04 Calories per step (TBD) */ 
  u32CaloricExpenditure = (UINT32)(u32Steps_Counter*4/100);
  vfnShowCalories(u32CaloricExpenditure,18,90);                        
  vfnShowCalories(Calctr,4,90); 

}
 
/*****************************************************************************/
/*                           Functions Definition
/*****************************************************************************/
 
void vfnShowCalories (UINT32 u32Calories,UINT8 u8ArrayXpos,UINT8 u8ArrayYpos){

  UINT8 CalSep[6], tms;
 
  CalSep[0]= u32Calories/10000;
  CalSep[1]= (u32Calories/1000)-(CalSep[0]*10);
  CalSep[2]= (u32Calories/100)-(CalSep[0]*100)-(CalSep[1]*10);
  CalSep[3]= (u32Calories/10)-(CalSep[0]*1000)-(CalSep[1]*100)-(CalSep[2]*10);
  CalSep[4]= u32Calories-(CalSep[0]*10000)-(CalSep[1]*1000)-(CalSep[2]*100)-(CalSep[3]*10);
 
  for(tms=0;tms<5;tms++){
    CalSep[tms]+=48;
  }
  
  CalSep[5]=0;
  New_fntcolor(Black,White);

  vfnClearFields(u8ArrayXpos,u8ArrayYpos,5); 
  Write_Str_LCD(&CalSep[0],u8ArrayXpos,u8ArrayYpos);
}